<?php 
require_once("../includes/config.php");
$arrstatus = getFullStatus("",$link1);
///// get access location details
$access_loc = getAccessLocation($_SESSION['userid'],$link1);
////// filters value/////
$daterange=$_REQUEST['daterange'];
$req_from=base64_decode($_REQUEST['req_from']);
//$req_to=base64_decode($_REQUEST['req_to']);
$status=base64_decode($_REQUEST['status']);

//////// get date /////////////////////////
if ($_REQUEST['daterange'] != ""){
$seldate = explode(" - ",$_REQUEST['daterange']);
$fromdate = $seldate[0];
$todate = $seldate[1];
}
else{
$seldate = $today;
$fromdate = date("Y-m-01");
$todate = $today;
}
## selected Status
if(!empty($status)){
	$req_status_str=" and status='".$status."'";
}else{
	$req_status_str=" ";
}
## selected from ID
if(!empty($req_from)){
	$req_from_str=" and to_location='".$req_from."'";
}else{
	$req_from_str=" and to_location in (".$access_loc.")";
}
## selected to ID
/*if(!empty($req_to)){
	$req_to_str=" and to_location='".$req_to."'";
}else{
	$req_to_str="";
}*/
//////End filters value/////
/** Include PHPExcel */
require_once("../ExcelExportAPI/Classes/PHPExcel.php");

// Create new PHPExcel object
$objPHPExcel = new PHPExcel();

// Set document properties
$objPHPExcel->getProperties()->setCreator("Candour Software")
->setLastModifiedBy("Candour Software")
->setTitle("Office 2007 XLSX Allocation Data")
->setSubject("Office 2007 XLSX Allocation Data")
->setDescription("Allocation Data for Office 2007 XLSX.")
->setKeywords("office 2007 openxml php")
->setCategory("Allocation Data");
// Add some data
$objPHPExcel->setActiveSheetIndex(0)
->setCellValue('A1', 'Sr. No.')
->setCellValue('B1', 'Allocation From')
->setCellValue('C1', 'Allocation From Code')
->setCellValue('D1', 'Allocation To')
->setCellValue('E1', 'Allocation To Code')
->setCellValue('F1', 'Document No')

->setCellValue('G1', 'Part Name')
->setCellValue('H1', 'Part Code')
->setCellValue('I1', 'Conversion Factor')
->setCellValue('J1', 'Allocate Qty')
->setCellValue('K1', 'Purchase Unit')

->setCellValue('L1', 'Entry Date')
->setCellValue('M1', 'Entry Time')
->setCellValue('N1', 'Entry By')
->setCellValue('O1', 'Document Type')
->setCellValue('P1', 'Reference No')

->setCellValue('Q1', 'Receive By')
->setCellValue('R1', 'Receive By Code')
->setCellValue('S1', 'Receive By Date')
->setCellValue('T1', 'Receive By Time')

->setCellValue('U1', 'Cancel By')
->setCellValue('V1', 'IP Address (Cancel By)')
->setCellValue('W1', 'Cancel Date')
->setCellValue('X1', 'Cancel Time')
->setCellValue('Y1', 'Status');
///// Add Color in header
cellColor('A1:Y1', '90EE90');

$i=2;
$count=1;
$sql_loc=mysqli_query($link1,"Select * from allocate_master where (document_date >= '".$fromdate."' and document_date <='".$todate."') ".$req_from_str."  ".$req_status_str." ");
while($row_loc = mysqli_fetch_array($sql_loc)){	
	////////// select part wise details //////
	$sql_part = mysqli_query($link1,"Select * from allocate_data where document_no='".$row_loc['document_no']."'");
	while($row_part_wise = mysqli_fetch_array($sql_part)){
	
		///// Get part name ////////////
		$part=explode("~",getAnyDetails($row_part_wise['partcode'],"partcode,part_name","partcode","partcode_master",$link1));	
		$part_name=$part[1];
		
		////////// Get request from person info /////////////
		$user_from=explode("~",getAnyDetails($row_loc['from_location'],"location_code,locationname","location_code","location_master",$link1));	
		$user_from_name=$user_from[1];
		
		////////// Get request to person info /////////////
		$user_to=explode("~",getAnyDetails($row_loc['to_location'],"location_code,locationname","location_code","location_master",$link1));	
		$user_to_name=$user_to[1];
			
		$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$i, $count)
					->setCellValue('B'.$i, $user_from_name)
					->setCellValue('C'.$i, $row_loc['from_location'])
					->setCellValue('D'.$i, $user_to_name)
					->setCellValue('E'.$i, $row_loc['to_location'])
					->setCellValue('F'.$i, $row_loc['document_no'])
					
					->setCellValue('G'.$i, $part_name)
					->setCellValue('H'.$i, $row_part_wise['partcode'])
					->setCellValue('I'.$i, getQtyFormate($row_part_wise['conversion_factor'],6))
					->setCellValue('J'.$i, getQtyFormate($row_part_wise['allocate_qty'],6))
					->setCellValue('K'.$i, $row_part_wise['purchase_unit'])
					
					->setCellValue('L'.$i, dt_format($row_loc['document_date']))
					->setCellValue('M'.$i, time_format($row_loc['document_time']))
					->setCellValue('N'.$i, $row_loc['entry_by'])
					->setCellValue('O'.$i, $row_loc['document_type'])
					->setCellValue('P'.$i, $row_loc['ref_no'])
					
					->setCellValue('Q'.$i, "")
					->setCellValue('R'.$i, $row_loc['receive_by'])
					->setCellValue('S'.$i, dt_format($row_loc['receive_date']))
					->setCellValue('T'.$i, time_format($row_loc['receive_time']))
					
					->setCellValue('U'.$i, $row_loc['cancel_by'])
					->setCellValue('V'.$i, $row_loc['cancel_by_ip'])
					->setCellValue('W'.$i, dt_format($row_loc['cancel_date']))
					->setCellValue('X'.$i, time_format($row_loc['cancel_time']))
					->setCellValue('Y'.$i, $arrstatus[$row_loc['status']]);
						
					$count++;	
					$i++;			
	}
}
///// apply border on export sheet
$styleArray = array(
  'borders' => array(
    'allborders' => array(
      'style' => PHPExcel_Style_Border::BORDER_MEDIUM
    )
  )
);

$objPHPExcel->getActiveSheet()->getStyle('A1:Y'.($i-1))->applyFromArray($styleArray);
unset($styleArray);

// Rename worksheet
$objPHPExcel->getActiveSheet()->setTitle('Allocation Data');


// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);


// Redirect output to a client?s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="allocation_list_excel.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;
?>
