<?php

require_once("../includes/config.php");
$arrstatus = getFullStatus("", $link1);

## selected  Request From
if (!empty(base64_decode($_REQUEST['location']))) {
    $req_from = " location_code ='" . base64_decode($_REQUEST['location']) . "' ";
} else {
    $req_from = " 1 ";
}
//////End filters value/////

/** Include PHPExcel */
require_once("../ExcelExportAPI/Classes/PHPExcel.php");

// Create new PHPExcel object
$objPHPExcel = new PHPExcel();

// Set document properties
$objPHPExcel->getProperties()->setCreator("Candour Software")
        ->setLastModifiedBy("Candour Software")
        ->setTitle("Office 2007 XLSX Bin Change Data")
        ->setSubject("Office 2007 XLSX Bin Change Data")
        ->setDescription("Bin Change Data for Office 2007 XLSX.")
        ->setKeywords("office 2007 openxml php")
        ->setCategory("Bin Change Data");
// Add some data
$objPHPExcel->setActiveSheetIndex(0)
        ->setCellValue('A1', 'Sr. No.')
        ->setCellValue('B1', 'Partcode')
        ->setCellValue('C1', 'Part Name')
        ->setCellValue('D1', 'Item Qty')
        ->setCellValue('E1', 'Old Bin')
        ->setCellValue('F1', 'New Bin')
        ->setCellValue('G1', 'Action')
        ->setCellValue('H1', 'Update Date')        
        ->setCellValue('I1', 'Update By Code')
        ->setCellValue('J1', 'Update By Name');
///// Add Color in header
cellColor('A1:J1', '90EE90');

$i = 2;
$count = 1;
////////// get data from stock return master /////////////
$sql = mysqli_query($link1, "Select * FROM change_bin where  " . $req_from . " ");

while ($row = mysqli_fetch_assoc($sql)) {
   
    ////////// get name /////////////
	$part_name = getAnyDetails($row['partcode'], "part_name", "partcode", "partcode_master", $link1);
	$user_name = getAnyDetails($row['location_code'], "locationname", "location_code", "location_master", $link1);
 
    $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A' . $i, $count)
            ->setCellValue('B' . $i, $row['partcode'])
            ->setCellValue('C' . $i, $part_name)
            ->setCellValue('D' . $i, $row['bin_qty'])
            ->setCellValue('E' . $i, $row['ref_bin'])
            ->setCellValue('F' . $i, $row['bin_no'])
            ->setCellValue('G' . $i, $row['action'])
            ->setCellValue('H' . $i, $row['updatedate'])
            ->setCellValue('I' . $i, $row['location_code'])
            ->setCellValue('J' . $i, $user_name);

    $count++;
    $i++;
}

///// apply border on export sheet
$styleArray = array(
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_MEDIUM
        )
    )
);

$objPHPExcel->getActiveSheet()->getStyle('A1:J' . ($i - 1))->applyFromArray($styleArray);
unset($styleArray);

// Rename worksheet
$objPHPExcel->getActiveSheet()->setTitle('Bin Change Report');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);

////////////////////////////////////second sheet end//////////////////////////////////////
// Redirect output to a client?s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="bin_change_excel.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;
?>
