<?php

require_once("../includes/config.php");
////// filters value/////
$location = base64_decode($_REQUEST['location']);
$stk_type = base64_decode($_REQUEST['stock_type']);
$prodcat = base64_decode($_REQUEST['prod_cat']);
$prodsubcat = base64_decode($_REQUEST['product_sub_category']);
$brand = base64_decode($_REQUEST['brandname']);

## selected Location
if (!empty($location)) {
    $location_str = " location_code='" . $location . "'";
} else {
    $location_str = " location_code='" . $location . "'";
}
if (!empty($stk_type)) {
    $stocktype = "stock_type='" . $stk_type . "'";
    $itemtype = "itemtypeid='" . $stk_type . "'";
} else {
    $stocktype = " 1";
    $itemtype = "1";
}
## selected product category
if (!empty($prodcat)) {
    $productCategory = "productid='" . $prodcat . "'";
} else {
    $productCategory = "1";
}
## selected product sub category
if (!empty($prodsubcat)) {
    $subCategory = "psubcatid='" . $prodsubcat . "'";
} else {
    $subCategory = "1";
}
## selected brand
if (!empty($brand)) {
    $brand_name = "brandid='" . $brand . "'";
} else {
    $brand_name = "1";
}
///// make partcode string on the basis of selection
$part_str = "";
if (!empty($productCategory) || !empty($prodsubcat) || !empty($brand)) {
    $res_part = mysqli_query($link1, "select partcode from partcode_master where " . $productCategory . " and " . $subCategory . " and " . $brand_name . " and " . $itemtype . "");
    while ($row = mysqli_fetch_array($res_part)) {
        if ($part_str == "") {
            $part_str .= "'" . $row['partcode'] . "'";
        } else {
            $part_str .= ",'" . $row['partcode'] . "'";
        }
    }
    if (!empty($part_str)) {
        
    } else {
        $part_str = "''";
    }
    $partstr = " and partcode in (" . $part_str . ")";
} else {
    $partstr = "";
}
//////End filters value/////
/** Include PHPExcel */
require_once("../ExcelExportAPI/Classes/PHPExcel.php");

// Create new PHPExcel object
$objPHPExcel = new PHPExcel();

// Set document properties
$objPHPExcel->getProperties()->setCreator("Candour Software")
        ->setLastModifiedBy("Candour Software")
        ->setTitle("Office 2007 XLSX Inventory Stock Data")
        ->setSubject("Office 2007 XLSX Inventory Stock Data")
        ->setDescription("Inventory Stock Data for Office 2007 XLSX.")
        ->setKeywords("office 2007 openxml php")
        ->setCategory("Inventory Stock Data");
// Add some data
$objPHPExcel->setActiveSheetIndex(0)
        ->setCellValue('A1', 'Sr. No.')
        ->setCellValue('B1', 'Location Name')
        ->setCellValue('C1', 'Location Code')
        ->setCellValue('D1', 'Brand')
        ->setCellValue('E1', 'Product Category')
        ->setCellValue('F1', 'Product Sub Category')
        ->setCellValue('G1', 'Part Name')
        ->setCellValue('H1', 'Part Code')
        ->setCellValue('I1', 'Stock Type')
        ->setCellValue('J1', 'OK Qty')
        ->setCellValue('K1', 'Damage Qty')
        ->setCellValue('L1', 'Missing Qty')
        ->setCellValue('M1', 'Purchase Unit');
///// Add Color in header
cellColor('A1:M1', '90EE90');

$i = 2;
$count = 1;
$sql_loc = mysqli_query($link1, "Select * from inventory_status where " . $location_str . " and " . $stocktype . " " . $partstr . "");

while ($row_loc = mysqli_fetch_array($sql_loc)) {
    $sql = mysqli_query($link1, "Select brandid,productid,psubcatid from partcode_master where partcode='" . $row_loc["partcode"] . "'");
    $row_part = mysqli_fetch_assoc($sql);
    
    $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A' . $i, $count)
            ->setCellValue('B' . $i, getAnyDetails($row_loc["location_code"], "locationname", "location_code", "location_master", $link1))
            ->setCellValue('C' . $i, $row_loc["location_code"])
            ->setCellValue('D' . $i, getAnyDetails($row_part["brandid"], "brand", "brandid", "brand_master", $link1))
            ->setCellValue('E' . $i, getAnyDetails($row_part["productid"], "product_name", "productid", "product_master", $link1))
            ->setCellValue('F' . $i, getAnyDetails($row_part["psubcatid"], "prod_sub_cat", "psubcatid", "product_sub_category", $link1))
            ->setCellValue('G' . $i, getAnyDetails($row_loc["partcode"], "part_name", "partcode", "partcode_master", $link1))
            ->setCellValue('H' . $i, $row_loc["partcode"])
            ->setCellValue('I' . $i, getAnyDetails($row_loc['stock_type'], "parttype", "typeid", "part_type_master", $link1))
            ->setCellValue('J' . $i, getQtyFormate($row_loc['ok_qty'], 6))
            ->setCellValue('K' . $i, getQtyFormate($row_loc['damage_qty'], 6))
            ->setCellValue('L' . $i, getQtyFormate($row_loc['missing_qty'], 6))
            ->setCellValue('M' . $i, $row_loc['purchase_unit']);

    $count++;
    $i++;
}
///// apply border on export sheet
$styleArray = array(
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_MEDIUM
        )
    )
);

$objPHPExcel->getActiveSheet()->getStyle('A1:M' . ($i - 1))->applyFromArray($styleArray);
unset($styleArray);

// Rename worksheet
$objPHPExcel->getActiveSheet()->setTitle('Inventory Stock');

////////////////////////////////////second sheet start bin//////////////////////////////////////////////////////
// Create a new worksheet, after the default sheet
$objPHPExcel->createSheet();

// Add some data to the second sheet, resembling some different data types

$objPHPExcel->setActiveSheetIndex(1)
        ->setCellValue('A1', 'Sr. No.')
        ->setCellValue('B1', 'Partcode')
        ->setCellValue('C1', 'Bin No.')
        ->setCellValue('D1', 'Qty')
        ->setCellValue('E1', 'Stock Type');

///// Add Color in header
cellColor('A1:E1', '90EE90');

$i = 2;
$count = 1;
$sql_loc = mysqli_query($link1, "Select partcode,location_code from inventory_status where " . $location_str . " and " . $stocktype . " " . $partstr . "");

while ($row_loc = mysqli_fetch_array($sql_loc)) {
    $sql = mysqli_query($link1, "Select * from bin_allocation where partcode='" . $row_loc["partcode"] . "' and location_code='" . $row_loc["location_code"] . "'");
    $row_bin = mysqli_fetch_assoc($sql);
    if($row_bin["bin_id"] !=""){
    if($row_bin["stock_type"]=='ok-qty'){ $stock ="Ok";}else if($row_bin["stock_type"]=='damage-qty'){ $stock ="Damage";}else{$stock ="";}
    $objPHPExcel->setActiveSheetIndex(1)
            ->setCellValue('A' . $i, $count)
            ->setCellValue('B' . $i, $row_loc["partcode"])
            ->setCellValue('C' . $i, getAnyDetails($row_bin["bin_id"], "bin_no", "bin_id", "bin_master", $link1))
            ->setCellValue('D' . $i, $row_bin["qty"])
            ->setCellValue('E' . $i, $stock);
           
    $count++;
    $i++;
}}

// Rename 2nd sheet
$objPHPExcel->getActiveSheet()->setTitle('Bin Data');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);

////////////////////////////////////second sheet end bin//////////////////////////////////////////////////////



// Redirect output to a client?s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="inventory_status_excel.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');



////////////////////////send excel data/////////////////////////


exit;
?>
