<?php 
require_once("../includes/config.php");
$arrstatus = getFullStatus("",$link1);
///// get access location details
$access_loc = getAccessLocation($_SESSION['userid'],$link1);
////// filters value/////
$daterange=$_REQUEST['daterange'];
$req_from=base64_decode($_REQUEST['location']);

//////// get date /////////////////////////
if ($_REQUEST['daterange'] != ""){
$seldate = explode(" - ",$_REQUEST['daterange']);
$fromdate = $seldate[0];
$todate = $seldate[1];
}
else{
$seldate = $today;
$fromdate = date("Y-m-01");
$todate = $today;
}

## selected from ID
if(!empty($req_from)){
	$location_str=" and location_code='".$req_from."'";
}else{
	$location_str=" and location_code in (".$access_loc.")";
}

//////End filters value/////
/** Include PHPExcel */
require_once("../ExcelExportAPI/Classes/PHPExcel.php");

// Create new PHPExcel object
$objPHPExcel = new PHPExcel();

// Set document properties
$objPHPExcel->getProperties()->setCreator("Candour Software")
->setLastModifiedBy("Candour Software")
->setTitle("Office 2007 XLSX Opening Stock Data")
->setSubject("Office 2007 XLSX Opening Stock Data")
->setDescription("Opening Stock Data for Office 2007 XLSX.")
->setKeywords("office 2007 openxml php")
->setCategory("Opening Stock Data");
// Add some data
$objPHPExcel->setActiveSheetIndex(0)
->setCellValue('A1', 'Sr. No.')
->setCellValue('B1', 'Location')
->setCellValue('C1', 'Location Code')
->setCellValue('D1', 'Stock Type')
->setCellValue('E1', 'Stock Category')
->setCellValue('F1', 'Document No')

->setCellValue('G1', 'Part Name')
->setCellValue('H1', 'Part Code')
->setCellValue('I1', 'Qty')
->setCellValue('J1', 'Price')
->setCellValue('K1', 'Value')
->setCellValue('L1', 'Purchase Unit')

->setCellValue('M1', 'Entry Date')
->setCellValue('N1', 'Entry Time')
->setCellValue('O1', 'Entry By')
->setCellValue('P1', 'Entry By(IP Address)')
->setCellValue('Q1', 'Entry Remark')
->setCellValue('R1', 'Cancel By')
->setCellValue('S1', 'Cancel By(IP Address)')
->setCellValue('T1', 'Cancel Date')
->setCellValue('U1', 'Cancellation Remarks')
->setCellValue('V1', 'File Name')
->setCellValue('W1', 'Status');
///// Add Color in header
cellColor('A1:W1', '90EE90');

$i=2;
$count=1;
$sql_loc=mysqli_query($link1,"Select * from opening_stock_master where (entry_date >= '".$fromdate."' and entry_date <='".$todate."') ".$location_str." ");
while($row_loc = mysqli_fetch_array($sql_loc)){	
	////////// select part wise details //////
	$sql_part = mysqli_query($link1,"Select * from opening_stock_data where document_no='".$row_loc['document_no']."'");
	while($row_part_wise = mysqli_fetch_array($sql_part)){
	
		///// Get part name ////////////
		$part=explode("~",getAnyDetails($row_part_wise['partcode'],"partcode,part_name","partcode","partcode_master",$link1));	
		$part_name=$part[1];
		
		////////// Get request from person info /////////////
		$user_from=explode("~",getAnyDetails($row_loc['location_code'],"location_code,locationname","location_code","location_master",$link1));	
		$user_from_name=$user_from[1];
			
		$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$i, $count)
					->setCellValue('B'.$i, $user_from_name)
					->setCellValue('C'.$i, $row_loc['location_code'])
					->setCellValue('D'.$i, $row_loc['stock_cat'])
					->setCellValue('E'.$i, $row_loc['stock_type'])
					->setCellValue('F'.$i, $row_loc['document_no'])
					
					->setCellValue('G'.$i, $part_name)
					->setCellValue('H'.$i, $row_part_wise['partcode'])
					->setCellValue('I'.$i, getQtyFormate($row_part_wise['qty'],6))
					->setCellValue('J'.$i, $row_part_wise['price'])
					->setCellValue('K'.$i, $row_part_wise['value'])
					->setCellValue('L'.$i, $row_part_wise['purchase_unit'])
					
					->setCellValue('M'.$i, dt_format($row_loc['entry_date']))
					->setCellValue('N'.$i, time_format($row_loc['entry_time']))
					->setCellValue('O'.$i, $row_loc['entry_by'])
					->setCellValue('P'.$i, $row_loc['entry_ip'])
					->setCellValue('Q'.$i, $row_loc['remark'])
					->setCellValue('R'.$i, $row_loc['cancel_by'])
					->setCellValue('S'.$i, $row_loc['cancel_ip'])
					->setCellValue('T'.$i, dt_format($row_loc['cancel_date']))
					->setCellValue('U'.$i, $row_loc['cancel_remark'])
					->setCellValue('V'.$i, $row_loc['file_name'])
					->setCellValue('W'.$i, $arrstatus[$row_loc['status']]);
						
					$count++;	
					$i++;			
	}
}
///// apply border on export sheet
$styleArray = array(
  'borders' => array(
    'allborders' => array(
      'style' => PHPExcel_Style_Border::BORDER_MEDIUM
    )
  )
);

$objPHPExcel->getActiveSheet()->getStyle('A1:W'.($i-1))->applyFromArray($styleArray);
unset($styleArray);

// Rename worksheet
$objPHPExcel->getActiveSheet()->setTitle('Opening Stock Data');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);

// Redirect output to a client?s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="opening_stock_list_excel.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;
?>
