<?php 
require_once("../includes/config.php");

///////// for page ///////
if(isset($_REQUEST['pid'])){ $pidvar = $_REQUEST['pid']; }else{ $pidvar = "";}

///////// required data /////////
if(isset($_REQUEST['status'])){ $statusvar = $_REQUEST['status']; }else{ $statusvar = "";}
if(isset($_REQUEST['req_from'])){ $request_fromvar = $_REQUEST['req_from']; }else{ $request_fromvar = "";}
if(isset($_REQUEST['req_to'])){ $request_tovar = $_REQUEST['req_to']; }else{ $request_tovar = "";}
if(isset($_REQUEST['daterange'])){ $daterangevar = $_REQUEST['daterange']; }else{ $daterangevar = "";}

$arrstatus = getFullStatus("",$link1);
///// get access location details
$access_loc = getAccessLocation($_SESSION['userid'],$link1);
////// filters value/////
$daterange = $daterangevar;
$req_from=base64_decode($request_fromvar);
$req_to=base64_decode($request_tovar);
$status=base64_decode($statusvar);

//////// get date /////////////////////////
if ($daterangevar != ""){
$seldate = explode(" - ",$daterangevar);
$fromdate = $seldate[0];
$todate = $seldate[1];
}
else{
$seldate = $today;
$fromdate = date("Y-m-01");
$todate = $today;
}
## selected from ID
if(!empty($req_from)){
	$req_from_str=" and from_location='".$req_from."'";
}else{
	$req_from_str=" and from_location in (".$access_loc.")";
}
## selected to ID
if(!empty($req_to)){
	$req_to_str=" and to_location='".$req_to."'";
}else{
	$req_to_str="";
}
## selected Status
if(!empty($status)){
	$req_status_str=" and status='".$status."'";
}else{
	$req_status_str="";
}
//////End filters value/////
/** Include PHPExcel */
require_once("../ExcelExportAPI/Classes/PHPExcel.php");

// Create new PHPExcel object
$objPHPExcel = new PHPExcel();

// Set document properties
$objPHPExcel->getProperties()->setCreator("Candour Software")
->setLastModifiedBy("Candour Software")
->setTitle("Office 2007 XLSX PO Status Data")
->setSubject("Office 2007 XLSX PO Status Data")
->setDescription("PO Status Data for Office 2007 XLSX.")
->setKeywords("office 2007 openxml php")
->setCategory("PO Status Data");
// Add some data
$objPHPExcel->setActiveSheetIndex(0)
->setCellValue('A1', 'Sr. No.')
->setCellValue('B1', 'Raise From')
->setCellValue('C1', 'Raise From Code')
->setCellValue('D1', 'Raise To')
->setCellValue('E1', 'Raise To Code')
->setCellValue('F1', 'Reference No')

->setCellValue('G1', 'Part Name')
->setCellValue('H1', 'Part Code')
->setCellValue('I1', 'Request Qty')
->setCellValue('J1', 'Invoice Qty')
->setCellValue('K1', 'Pending Qty')
->setCellValue('L1', 'Receive Qty')
->setCellValue('M1', 'OK Qty')
->setCellValue('N1', 'Damage Qty')
->setCellValue('O1', 'Missing Qty')
->setCellValue('P1', 'Price')
->setCellValue('Q1', 'Value')
->setCellValue('R1', 'Scheduled Date')
->setCellValue('S1', 'Purchase Unit')
->setCellValue('T1', 'Part Remark')

->setCellValue('U1', 'Entry Date')
->setCellValue('V1', 'Entry Time')
->setCellValue('W1', 'Entry By')
->setCellValue('X1', 'Entry By(IP Address)')
->setCellValue('Y1', 'Document Type')
->setCellValue('Z1', 'Reference Remark')
->setCellValue('AA1', 'Cancel By')
->setCellValue('AB1', 'Cancel By(IP Address)')
->setCellValue('AC1', 'Cancel Date')
->setCellValue('AD1', 'Cancellation Remarks')
->setCellValue('AE1', 'Status');
///// Add Color in header
cellColor('A1:AE1', '90EE90');

$i=2;
$count=1;

$sql_loc=mysqli_query($link1,"Select * from po_master where (entry_date >= '".$fromdate."' and entry_date <='".$todate."') ".$req_from_str." ".$req_to_str."  ".$req_status_str." ");
while($row_loc = mysqli_fetch_array($sql_loc)){	
	////////// select part wise details //////
	$sql_part = mysqli_query($link1,"Select * from po_data where system_ref_no='".$row_loc['system_ref_no']."'");
	while($row_part_wise = mysqli_fetch_array($sql_part)){
	
		///// Get part name ////////////
		$part=explode("~",getAnyDetails($row_part_wise['partcode'],"partcode,part_name","partcode","partcode_master",$link1));	
		$part_name=$part[1];
		
		////////// Get request from person info /////////////
		$user_from=explode("~",getAnyDetails($row_loc['from_location'],"location_code,locationname","location_code","location_master",$link1));	
		$user_from_name=$user_from[1];

		////////// Get request to person info /////////////
		$user_to=explode("~",getAnyDetails($row_loc['to_location'],"vendor_code,vendor_name","vendor_code","vendor_master",$link1));	
		$user_to_name=$user_to[1];
			
		$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$i, $count)
					->setCellValue('B'.$i, $user_from_name)
					->setCellValue('C'.$i, $row_loc['from_location'])
					->setCellValue('D'.$i, $user_to_name)
					->setCellValue('E'.$i, $row_loc['to_location'])
					->setCellValue('F'.$i, $row_loc['system_ref_no'])
					
					->setCellValue('G'.$i, $part_name)
					->setCellValue('H'.$i, $row_part_wise['partcode'])
					->setCellValue('I'.$i, getQtyFormate($row_part_wise['req_qty'],6))
					->setCellValue('J'.$i, getQtyFormate($row_part_wise['inv_qty'],6))
					->setCellValue('K'.$i, getQtyFormate($row_part_wise['pending_qty'],6))
					->setCellValue('L'.$i, getQtyFormate($row_part_wise['rec_qty'],6))
					->setCellValue('M'.$i, getQtyFormate($row_part_wise['ok_qty'],6))
					->setCellValue('N'.$i, getQtyFormate($row_part_wise['damage_qty'],6))
					->setCellValue('O'.$i, getQtyFormate($row_part_wise['missing_qty'],6))
					->setCellValue('P'.$i, $row_part_wise['price'])
					->setCellValue('Q'.$i, $row_part_wise['value'])
					->setCellValue('R'.$i, dt_format($row_part_wise['schedule_date']))
					->setCellValue('S'.$i, $row_part_wise['purchase_unit'])
					->setCellValue('T'.$i, $row_part_wise['remark'])
					
					->setCellValue('U'.$i, dt_format($row_loc['entry_date']))
					->setCellValue('V'.$i, time_format($row_loc['entry_time']))
					->setCellValue('W'.$i, $row_loc['entry_by'])
					->setCellValue('X'.$i, $row_loc['entry_ip'])
					->setCellValue('Y'.$i, $row_loc['document_type'])
					->setCellValue('Z'.$i, $row_loc['remark'])
					->setCellValue('AA'.$i, $row_loc['cancel_by'])
					->setCellValue('AB'.$i, $row_loc['cancel_ip'])
					->setCellValue('AC'.$i, dt_format($row_loc['cancel_date']))
					->setCellValue('AD'.$i, $row_loc['cancel_remark'])
					->setCellValue('AE'.$i, $arrstatus[$row_loc['status']]);
						
					$count++;	
					$i++;			
	}
}
///// apply border on export sheet
$styleArray = array(
  'borders' => array(
    'allborders' => array(
      'style' => PHPExcel_Style_Border::BORDER_MEDIUM
    )
  )
);

$objPHPExcel->getActiveSheet()->getStyle('A1:AE'.($i-1))->applyFromArray($styleArray);
unset($styleArray);

// Rename worksheet
$objPHPExcel->getActiveSheet()->setTitle('PO Status Data');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);

// Redirect output to a client?s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="po_status_list_excel.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;
?>
