<?php 
require_once("../includes/config.php");
$arrstatus = getFullStatus("",$link1);
///// get access location details
$access_loc = getAccessLocation($_SESSION['userid'],$link1);
////// filters value/////
$daterange=$_REQUEST['daterange'];
$req_from=base64_decode($_REQUEST['req_from']);
$req_to=base64_decode($_REQUEST['req_to']);
$status=base64_decode($_REQUEST['status']);

//////// get date /////////////////////////
if ($_REQUEST['daterange'] != ""){
$seldate = explode(" - ",$_REQUEST['daterange']);
$fromdate = $seldate[0];
$todate = $seldate[1];
}
else{
$seldate = $today;
$fromdate = date("Y-m-01");
$todate = $today;
}
## selected Status
if(!empty($status)){
	$req_status_str=" and status='".$status."'";
}else{
	$req_status_str="";
}
## selected from ID
if(!empty($req_from)){
	$req_from_str=" and request_from='".$req_from."'";
}else{
	$req_from_str=" and request_from in (".$access_loc.")";
}
## selected to ID
if(!empty($req_to)){
	$req_to_str=" and request_to='".$req_to."'";
}else{
	$req_to_str=" and request_to in (".$access_loc.")";
}
//////End filters value/////
/** Include PHPExcel */
require_once("../ExcelExportAPI/Classes/PHPExcel.php");

// Create new PHPExcel object
$objPHPExcel = new PHPExcel();

// Set document properties
$objPHPExcel->getProperties()->setCreator("Candour Software")
->setLastModifiedBy("Candour Software")
->setTitle("Office 2007 XLSX Requisition Data")
->setSubject("Office 2007 XLSX Requisition Data")
->setDescription("Requisition Data for Office 2007 XLSX.")
->setKeywords("office 2007 openxml php")
->setCategory("Requisition Data");
// Add some data
$objPHPExcel->setActiveSheetIndex(0)
->setCellValue('A1', 'Sr. No.')
->setCellValue('B1', 'Request From')
->setCellValue('C1', 'Request From Code')
->setCellValue('D1', 'Request To')
->setCellValue('E1', 'Request To Code')
->setCellValue('F1', 'Reference No')

->setCellValue('G1', 'Part Name')
->setCellValue('H1', 'Part Code')
->setCellValue('I1', 'Request Qty')
->setCellValue('J1', 'Allocate Qty')
->setCellValue('K1', 'Purchase Unit')
->setCellValue('L1', 'Part Remark')

->setCellValue('M1', 'Entry Date')
->setCellValue('N1', 'Entry Time')
->setCellValue('O1', 'Entry By')
->setCellValue('P1', 'Entry By(IP Address)')
->setCellValue('Q1', 'Person Name')
->setCellValue('R1', 'Request Type')
->setCellValue('S1', 'Job Reference No')
->setCellValue('T1', 'Reference Remark')
->setCellValue('U1', 'Cancel By')
->setCellValue('V1', 'Cancel By(IP Address)')
->setCellValue('W1', 'Cancel Date')
->setCellValue('X1', 'Cancellation Remarks')
->setCellValue('Y1', 'Status');
///// Add Color in header
cellColor('A1:Y1', '90EE90');

$i=2;
$count=1;
$sql_loc=mysqli_query($link1,"Select * from requisition_master where (entry_date >= '".$fromdate."' and entry_date <='".$todate."') ".$req_from_str." ".$req_to_str."  ".$req_status_str." ");
while($row_loc = mysqli_fetch_array($sql_loc)){	
	////////// select part wise details //////
	$sql_part = mysqli_query($link1,"Select * from requisition_data where system_ref_no='".$row_loc['system_ref_no']."'");
	while($row_part_wise = mysqli_fetch_array($sql_part)){
	
		///// Get part name ////////////
		$part=explode("~",getAnyDetails($row_part_wise['partcode'],"partcode,part_name","partcode","partcode_master",$link1));	
		$part_name=$part[1];
		
		////////// Get request from person info /////////////
		$user_from=explode("~",getAnyDetails($row_loc['request_from'],"location_code,locationname","location_code","location_master",$link1));	
		$user_from_name=$user_from[1];

		////////// Get request to person info /////////////
		$user_to=explode("~",getAnyDetails($row_loc['request_to'],"location_code,locationname","location_code","location_master",$link1));	
		$user_to_name=$user_to[1];
			
		$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$i, $count)
					->setCellValue('B'.$i, $user_from_name)
					->setCellValue('C'.$i, $row_loc['request_from'])
					->setCellValue('D'.$i, $user_to_name)
					->setCellValue('E'.$i, $row_loc['request_to'])
					->setCellValue('F'.$i, $row_loc['system_ref_no'])
					
					->setCellValue('G'.$i, $part_name)
					->setCellValue('H'.$i, $row_part_wise['partcode'])
					->setCellValue('I'.$i, getQtyFormate($row_part_wise['req_qty'],6))
					->setCellValue('J'.$i, getQtyFormate($row_part_wise['allocate_qty'],6))
					->setCellValue('K'.$i, $row_part_wise['purchase_unit'])
					->setCellValue('L'.$i, $row_part_wise['remark'])
					
					->setCellValue('M'.$i, dt_format($row_loc['entry_date']))
					->setCellValue('N'.$i, time_format($row_loc['entry_time']))
					->setCellValue('O'.$i, $row_loc['entry_by'])
					->setCellValue('P'.$i, $row_loc['entry_ip'])
					->setCellValue('Q'.$i, $row_loc['person_name'])
					->setCellValue('R'.$i, $row_loc['req_type'])
					->setCellValue('S'.$i, $row_loc['ref_no'])
					->setCellValue('T'.$i, $row_loc['remark'])
					->setCellValue('U'.$i, $row_loc['cancel_by'])
					->setCellValue('V'.$i, $row_loc['cancel_ip'])
					->setCellValue('W'.$i, dt_format($row_loc['cancel_date']))
					->setCellValue('X'.$i, $row_loc['cancel_remark'])
					->setCellValue('Y'.$i, $arrstatus[$row_loc['status']]);
						
					$count++;	
					$i++;			
	}
}
///// apply border on export sheet
$styleArray = array(
  'borders' => array(
    'allborders' => array(
      'style' => PHPExcel_Style_Border::BORDER_MEDIUM
    )
  )
);

$objPHPExcel->getActiveSheet()->getStyle('A1:Y'.($i-1))->applyFromArray($styleArray);
unset($styleArray);

// Rename worksheet
$objPHPExcel->getActiveSheet()->setTitle('Requisition Data');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);

// Redirect output to a client?s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="requisition_list_excel.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;
?>
