<?php

require_once("../includes/config.php");
$arrstatus = getFullStatus("", $link1);

////// filters value/////

$partcode = base64_decode($_REQUEST['id']);

## selected  Request From
if (!empty($_REQUEST['location'])) {
    $req_from = " and from_location ='" . $_REQUEST['location'] . "'";
} else {
    $req_from = "";
}
## selected  Request To
if (!empty($_REQUEST['vendor'])) {
    $req_to = " and to_location ='" . $_REQUEST['vendor'] . "'";
} else {
    $req_to = "";
}
//////// get date /////////////////////////
if ($_REQUEST['daterange'] != "") {
    $seldate = explode(" - ", $_REQUEST['daterange']);
    $fromdate = $seldate[0];
    $todate = $seldate[1];
} else {
    $seldate = $today;
    $fromdate = date("Y-m-01");
    $todate = $today;
}
$str ="";
if($_REQUEST['date']=='return'){
    $str = 'entry_date';
}else{
    $str = 'ref_date';
}
//////End filters value/////

/** Include PHPExcel */
require_once("../ExcelExportAPI/Classes/PHPExcel.php");

// Create new PHPExcel object
$objPHPExcel = new PHPExcel();

// Set document properties
$objPHPExcel->getProperties()->setCreator("Candour Software")
        ->setLastModifiedBy("Candour Software")
        ->setTitle("Office 2007 XLSX Return Stock Data")
        ->setSubject("Office 2007 XLSX Return Stock Data")
        ->setDescription("Return Stock Data for Office 2007 XLSX.")
        ->setKeywords("office 2007 openxml php")
        ->setCategory("Return Stock Data");
// Add some data
$objPHPExcel->setActiveSheetIndex(0)
        ->setCellValue('A1', 'Sr. No.')
        ->setCellValue('B1', 'System Ref No.')
        ->setCellValue('C1', 'Location')
        ->setCellValue('D1', 'Vendor')
        ->setCellValue('E1', 'Document Type')
        ->setCellValue('F1', 'Stock Type')
        ->setCellValue('G1', 'Invoice No.')
        ->setCellValue('H1', 'Invoice Date')        
        ->setCellValue('I1', 'Sub Total')
        ->setCellValue('J1', 'Discount')
        ->setCellValue('K1', 'Tax Total')
        ->setCellValue('L1', 'Other Charges')
        ->setCellValue('M1', 'Grand Total')
        ->setCellValue('N1', 'Status')
        ->setCellValue('O1', 'Courier Name')
        ->setCellValue('P1', 'Docket No.')
        ->setCellValue('Q1', 'Dispatch Date')
        ->setCellValue('R1', 'Dispatch Time')
        ->setCellValue('S1', 'Entry Date')
        ->setCellValue('T1', 'Entry Time')
        ->setCellValue('U1', 'Entry By')
        ->setCellValue('V1', 'Entry By(IP Address)')
        ->setCellValue('W1', 'Entry Remark')
        ->setCellValue('X1', 'Cancel By')
        ->setCellValue('Y1', 'Cancel By(IP Address)')
        ->setCellValue('Z1', 'Cancel Date')
        ->setCellValue('AA1', 'Cancellation Remarks');
///// Add Color in header
cellColor('A1:AA1', '90EE90');

$i = 2;
$count = 1;
////////// get data from stock return master /////////////
$sql = mysqli_query($link1, "Select * FROM return_master where  $str >='" . $fromdate . "' and $str <='" . $todate . "'  " . $req_from . "  " . $req_to . " ");

while ($row = mysqli_fetch_assoc($sql)) {
   
    ////////// get data location wise /////////////
    $user_from = getAnyDetails($row['from_location'], "locationname", "location_code", "location_master", $link1);
    $vendor = getAnyDetails($row['to_location'], "vendor_name", "vendor_code", "vendor_master", $link1);
    $user_from_name = $user_from[1];
    if($row['stock_type']='ok-qty'){
        $stock='Ok';
    }else{
        $stock='Damage';
    }
    $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A' . $i, $count)
            ->setCellValue('B' . $i, $row['system_ref_no'])
            ->setCellValue('C' . $i, $user_from)
            ->setCellValue('D' . $i, $vendor)
            ->setCellValue('E' . $i, $row['document_type'])
            ->setCellValue('F' . $i, $stock)
            ->setCellValue('G' . $i, $row['ref_no'])
            ->setCellValue('H' . $i, $row['ref_date'])
            ->setCellValue('I' . $i, $row['sub_total'])
            ->setCellValue('J' . $i, $row['discount'])
            ->setCellValue('K' . $i, $row['tax_total'])
            ->setCellValue('L' . $i, $row['other_charges'])
            ->setCellValue('M' . $i, $row['grand_total'])
            ->setCellValue('N' . $i, $arrstatus[$row['status']])
            ->setCellValue('O' . $i, $row['courier_name'])
            ->setCellValue('P' . $i, $row['docket_no'])
            ->setCellValue('Q' . $i, dt_format($row['dispatch_date']))
            ->setCellValue('R' . $i, time_format($row['dispatch_time']))
            ->setCellValue('S' . $i, dt_format($row['entry_date']))
            ->setCellValue('T' . $i, time_format($row['entry_time']))
            ->setCellValue('U' . $i, $row['entry_by'])
            ->setCellValue('V' . $i, $row['entry_ip'])
            ->setCellValue('W' . $i, $row['entry_remark'])
            ->setCellValue('X' . $i, $row['cancel_by'])
            ->setCellValue('Y' . $i, $row['cancel_ip'])
            ->setCellValue('Z' . $i, dt_format($row['cancel_date']))
            ->setCellValue('AA' . $i, $row['cancel_remark']);

    $count++;
    $i++;
}

///// apply border on export sheet
$styleArray = array(
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_MEDIUM
        )
    )
);

$objPHPExcel->getActiveSheet()->getStyle('A1:AA' . ($i - 1))->applyFromArray($styleArray);
unset($styleArray);

// Rename worksheet
$objPHPExcel->getActiveSheet()->setTitle('Summary Master');


////////////////////////////////////second sheet start //////////////////////////////////////////////////////
// Create a new worksheet, after the default sheet
$objPHPExcel->createSheet();

// Add some data to the second sheet, resembling some different data types

$objPHPExcel->setActiveSheetIndex(1)
        ->setCellValue('A1', 'Sr. No.')
        ->setCellValue('B1', 'Part Name')
        ->setCellValue('C1', 'Part Code')
        ->setCellValue('D1', 'Invoice Qty')
        ->setCellValue('E1', 'Return Qty')
        ->setCellValue('F1', 'Purchase Unit')        
        ->setCellValue('G1', 'Price')
        ->setCellValue('H1', 'Value')
        ->setCellValue('I1', 'Tax Type')
        ->setCellValue('J1', 'Tax %')
        ->setCellValue('K1', 'Tax Amt')
        ->setCellValue('L1', 'Total')
        ->setCellValue('M1', 'Remark')
        ->setCellValue('N1', 'Vendor Code');

///// Add Color in header
cellColor('A1:N1', '90EE90');

$i1 = 2;
$count1 = 1;
////////// get data from return stock master /////////////
$sql1 = mysqli_query($link1, "Select system_ref_no FROM return_master where  $str >='" . $fromdate . "' and $str <='" . $todate . "'  " . $req_from . "  " . $req_to . " ");
while ($row1 = mysqli_fetch_assoc($sql1)) {
   
    ////////// select part wise details from return_data//////
    $sql_part = mysqli_query($link1, "Select * from return_data where system_ref_no='" . $row1['system_ref_no'] . "'");
    while ($row_part_wise = mysqli_fetch_assoc($sql_part)) {
 
        ///// Get part name ////////////
        $part = explode("~", getAnyDetails($row_part_wise['partcode'], "partcode,part_name", "partcode", "partcode_master", $link1));
        
        $objPHPExcel->setActiveSheetIndex(1)
                ->setCellValue('A' . $i1, $count1)
                ->setCellValue('B' . $i1, $part[1])
                ->setCellValue('C' . $i1, $part[0])
                ->setCellValue('D' . $i1, getQtyFormate($row_part_wise['ref_qty'],6))
                ->setCellValue('E' . $i1, getQtyFormate($row_part_wise['return_qty'], 6))
                ->setCellValue('F' . $i1, $row_part_wise['purchase_unit'])
                ->setCellValue('G' . $i1, $row_part_wise['price'])
                ->setCellValue('H' . $i1, $row_part_wise['sub_total'])
                ->setCellValue('I' . $i1, $row_part_wise['tax_type'])
                ->setCellValue('J' . $i1, $row_part_wise['tax_per'])
                ->setCellValue('K' . $i1, $row_part_wise['tax_amt'])
                ->setCellValue('L' . $i1, $row_part_wise['grand_total'])
                ->setCellValue('M' . $i1, $row_part_wise['inv_remark'])
                ->setCellValue('N' . $i1, $row_part_wise['vendor_partcode']);
        $count1++;
        $i1++;
    }
}

// Rename 2nd sheet
$objPHPExcel->getActiveSheet()->setTitle('Details Data');


// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);

////////////////////////////////////second sheet end//////////////////////////////////////
// Redirect output to a client?s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="return_stock_excel.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;
?>
