<?php 
require_once("../includes/config.php");
$arrstatus = getFullStatus("",$link1);
///// get access location details
$access_loc = getAccessLocation($_SESSION['userid'],$link1);
////// filters value/////
$daterange=$_REQUEST['daterange'];
$req_from=base64_decode($_REQUEST['req_from']);
$req_to=base64_decode($_REQUEST['req_to']);
$status=base64_decode($_REQUEST['status']);

//////// get date /////////////////////////
if ($_REQUEST['daterange'] != ""){
$seldate = explode(" - ",$_REQUEST['daterange']);
$fromdate = $seldate[0];
$todate = $seldate[1];
}
else{
$seldate = $today;
$fromdate = date("Y-m-01");
$todate = $today;
}
## selected Status
if(!empty($status)){
	$req_status_str=" and status='".$status."'";
}else{
	$req_status_str="";
}
## selected from ID
if(!empty($req_from)){
	$req_from_str=" and from_location='".$req_from."'";
}else{
	$req_from_str=" and from_location in (".$access_loc.")";
}
## selected to ID
if(!empty($req_to)){
	$req_to_str=" and to_location='".$req_to."'";
}else{
	$req_to_str=" and to_location in (".$access_loc.")";
}
//////End filters value/////
/** Include PHPExcel */
require_once("../ExcelExportAPI/Classes/PHPExcel.php");

// Create new PHPExcel object
$objPHPExcel = new PHPExcel();

// Set document properties
$objPHPExcel->getProperties()->setCreator("Candour Software")
->setLastModifiedBy("Candour Software")
->setTitle("Office 2007 XLSX Stock Transfer Data")
->setSubject("Office 2007 XLSX Stock Transfer Data")
->setDescription("Stock Transfer Data for Office 2007 XLSX.")
->setKeywords("office 2007 openxml php")
->setCategory("Stock Transfer Data");
// Add some data
$objPHPExcel->setActiveSheetIndex(0)
->setCellValue('A1', 'Sr. No.')
->setCellValue('B1', 'Transfer From')
->setCellValue('C1', 'Transfer From Code')
->setCellValue('D1', 'Transfer To')
->setCellValue('E1', 'Transfer To Code')
->setCellValue('F1', 'Reference No')

->setCellValue('G1', 'Part Name')
->setCellValue('H1', 'Part Code')
->setCellValue('I1', 'Transfer Qty')
->setCellValue('J1', 'Purchase Unit')

->setCellValue('K1', 'Entry Date')
->setCellValue('L1', 'Entry Time')
->setCellValue('M1', 'Entry By')
->setCellValue('N1', 'Document Type')
->setCellValue('O1', 'Job Reference No')
->setCellValue('P1', 'Cancel By')
->setCellValue('Q1', 'Cancel By(IP Address)')
->setCellValue('R1', 'Cancel Date')
->setCellValue('S1', 'Cancellation Remarks')
->setCellValue('T1', 'Status');
///// Add Color in header
cellColor('A1:T1', '90EE90');

$i=2;
$count=1;
$sql_loc=mysqli_query($link1,"Select * from allocate_master where document_type='RTN' and (document_date >= '".$fromdate."' and document_date <='".$todate."') ".$req_from_str." ".$req_to_str."  ".$req_status_str." ");
while($row_loc = mysqli_fetch_array($sql_loc)){	
	////////// select part wise details //////
	$sql_part = mysqli_query($link1,"Select * from allocate_data where document_no='".$row_loc['document_no']."'");
	while($row_part_wise = mysqli_fetch_array($sql_part)){
	
		///// Get part name ////////////
		$part=explode("~",getAnyDetails($row_part_wise['partcode'],"partcode,part_name","partcode","partcode_master",$link1));	
		$part_name=$part[1];
		
		////////// Get request from person info /////////////
		$user_from=explode("~",getAnyDetails($row_loc['from_location'],"location_code,locationname","location_code","location_master",$link1));	
		$user_from_name=$user_from[1];

		////////// Get request to person info /////////////
		$user_to=explode("~",getAnyDetails($row_loc['to_location'],"location_code,locationname","location_code","location_master",$link1));	
		$user_to_name=$user_to[1];
			
		$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$i, $count)
					->setCellValue('B'.$i, $user_from_name)
					->setCellValue('C'.$i, $row_loc['from_location'])
					->setCellValue('D'.$i, $user_to_name)
					->setCellValue('E'.$i, $row_loc['to_location'])
					->setCellValue('F'.$i, $row_loc['document_no'])
					
					->setCellValue('G'.$i, $part_name)
					->setCellValue('H'.$i, $row_part_wise['partcode'])
					->setCellValue('I'.$i, getQtyFormate($row_part_wise['allocate_qty'],6))
					->setCellValue('J'.$i, $row_part_wise['purchase_unit'])
					
					->setCellValue('K'.$i, dt_format($row_loc['document_date']))
					->setCellValue('L'.$i, time_format($row_loc['document_time']))
					->setCellValue('M'.$i, $row_loc['entry_by'])
					->setCellValue('N'.$i, $row_loc['document_type'])
					->setCellValue('O'.$i, $row_loc['ref_no'])
					->setCellValue('P'.$i, $row_loc['cancel_by'])
					->setCellValue('Q'.$i, $row_loc['cancel_by_ip'])
					->setCellValue('R'.$i, dt_format($row_loc['cancel_date']))
					->setCellValue('S'.$i, $row_loc['cancel_rmk'])
					->setCellValue('T'.$i, $arrstatus[$row_loc['status']]);
						
					$count++;	
					$i++;			
	}
}
///// apply border on export sheet
$styleArray = array(
  'borders' => array(
    'allborders' => array(
      'style' => PHPExcel_Style_Border::BORDER_MEDIUM
    )
  )
);

$objPHPExcel->getActiveSheet()->getStyle('A1:T'.($i-1))->applyFromArray($styleArray);
unset($styleArray);

// Rename worksheet
$objPHPExcel->getActiveSheet()->setTitle('Stock Transfer Data');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);

// Redirect output to a client?s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="stock_transfer_list_excel.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;
?>
