<?php
//////// function for displaying error message
function errorMsg($errorcode){
	if($errorcode=="1") {
		$msg = "User Id Or Password Wrong! Please Try Again!";
	} else if($errorcode=="2") {
		$msg = "Session Expired! Please Login Again!";
	} else if($errorcode=="3") {
		$msg = "You have Successfuly Logged Out.";
	} else if($errorcode=="4") {
		$msg = "User Id is not found in record.";
	} else{ 
		$msg = $errorcode;
	}
	return $msg;
}
/////////// function to clean data///////
function cleanData($instr) {
	$str=trim(preg_replace('/ +/', ' ', preg_replace('/[^A-Za-z0-9 ]/', ' ', urldecode(html_entity_decode(strip_tags($instr))))));
	return $str;
}
//////// set currency format /////
function currencyFormat($amttt){
	return "<i class='fa fa-inr' aria-hidden='true'></i> ".number_format($amttt,'2','.','');
}
///// Function to get Qty formate 
function getQtyFormate($qty,$decimal_no){
	return number_format($qty, $decimal_no);
}
///////////////  date format like DD-MM-YYYY ////////////////
function dt_format($dt_sel){
	return substr($dt_sel,8,2)."-".substr($dt_sel,5,2)."-".substr($dt_sel,0,4);
}
///////////////  date format like MM/DD/YYYY ////////////////
function dt_format2($dt_sel){
	return substr($dt_sel,5,2)."/".substr($dt_sel,8,2)."/".substr($dt_sel,0,4);
}
///////////////  time format like HH:MM:SS ////////////////
function time_format($time_sel){
	return $time_sel;
}
////////// function to calculate day difference between two dates //////////
function daysDifference($endDate, $beginDate){
	$date_parts1=explode("-", $beginDate); $date_parts2=explode("-", $endDate);
	$start_date=gregoriantojd($date_parts1[1], $date_parts1[2], $date_parts1[0]);
	$end_date=gregoriantojd($date_parts2[1], $date_parts2[2], $date_parts2[0]);
	return $end_date - $start_date;
}
//////// function to capture daily activities /////
function dailyActivity($uid,$refno,$activityType,$actionTaken,$systemIp,$link1,$errorflag){
	$todayDate=date("Y-m-d");
	$todayTime=date("H:i:s");
	$flag=$errorflag;
	$query="INSERT INTO daily_activities set userid='".$uid."',ref_no='".$refno."',activity_type='".$activityType."',action_taken='".$actionTaken."',update_date='".$todayDate."',update_time='".$todayTime."',system_ip='".$systemIp."'";
	$result=mysqli_query($link1,$query);
	//// check if query is not executed
	if (!$result) {
		$flag = false;
		echo "Error detailsDA: " . mysqli_error($link1) . ".";
	}
	return $flag;
}
//////// function to capture job history /////
function jobHistory($refno,$loc_code,$activityType,$status,$rmk,$uid,$systemIp,$link1,$errorflag){
	$todayDate = date("Y-m-d H:i:s");
	$flag = $errorflag;
	$err_msg = "";
	$query="INSERT INTO job_history set job_no='".$refno."',location_code='".$loc_code."',activity_type='".$activityType."',status='".$status."',remark='".$rmk."',update_by='".$uid."',update_date='".$todayDate."',update_ip='".$systemIp."'";
	$result=mysqli_query($link1,$query);
	//// check if query is not executed
	if (!$result) {
		$flag = false;
		$err_msg = "Error detailsJH: " . mysqli_error($link1) . "";
	}
	return $flag."~".$err_msg;
}
//////// function to capture approval activities /////
function approvalActivity($refno,$reftype,$refdate,$refstatus,$uid,$actionTaken,$remark,$systemIp,$link1,$errorflag){
	$todayDate=date("Y-m-d");
	$todayTime=date("H:i:s");
	$flag=$errorflag;
	$query="INSERT INTO approval_activity set ref_no='".$refno."',ref_type='".$reftype."',ref_date='".$refdate."',ref_status='".$refstatus."',entry_date='".$todayDate."',action_by='".$uid."',action_taken='".$actionTaken."',action_date='".$todayDate."',action_time='".$todayTime."',action_remark='".$remark."',action_ip='".$systemIp."'";
	$result=mysqli_query($link1,$query);
	//// check if query is not executed
	if (!$result) {
		$flag = false;
		echo "Error detailsAA: " . mysqli_error($link1) . ".";
	}
	return $flag;
}
/////// function to get admin user details
function getAdminDetails($adminid,$fields,$link1){
	$explodee=explode(",",$fields);
	$user_details=mysqli_fetch_array(mysqli_query($link1,"select $fields from admin_users where username='".$adminid."'"));
	$rtn_str="";
	for($k=0;$k < count($explodee);$k++){
		if($rtn_str==""){
			$rtn_str.=$user_details[$k];
		}
		else{
			$rtn_str.="~".$user_details[$k];
		}
	}
	return $rtn_str;
}
/////// function to get Location  details
function getLocationDetails($locid,$fields,$link1){
	$explodee=explode(",",$fields);
	$user_details=mysqli_fetch_array(mysqli_query($link1,"select $fields from location_master where location_code='".$locid."'"));
	$rtn_str="";
	for($k=0;$k < count($explodee);$k++){
		if($rtn_str==""){
			$rtn_str.=$user_details[$k];
		}
		else{
			$rtn_str.="~".$user_details[$k];
		}
	}
	return $rtn_str;
}
/////// function to get Location  details
function getVendorDetails($vendorid,$fields,$link1){
	$explodee=explode(",",$fields);
	$user_details=mysqli_fetch_array(mysqli_query($link1,"select $fields from vendor_master where vendor_code='".$vendorid."'"));
	$rtn_str="";
	for($k=0;$k < count($explodee);$k++){
		if($rtn_str==""){
			$rtn_str.=$user_details[$k];
		}
		else{
			$rtn_str.="~".$user_details[$k];
		}
	}
	return $rtn_str;
}
//// get access location ////
function getAccessLocation($userid,$link1){
	$loction_str="";
	$res_parent=mysqli_query($link1,"select location_code from access_location where userid='".$userid."' and status='1'")or die(mysqli_error());
	if(mysqli_num_rows($res_parent)>0){
		while($row_parent=mysqli_fetch_assoc($res_parent)){
			if($loction_str==""){
				$loction_str.="'".$row_parent['location_code']."'";
			}else{
				$loction_str.=",'".$row_parent['location_code']."'";
			}
		}
	}else{
		$loction_str="''";
	}
	return $loction_str;
}
//// get access state ////
function getAccessState($userid,$link1){
	$state_str="";
	$res_state=mysqli_query($link1,"select stateid from access_region where userid='".$userid."' and status='Y' group by stateid")or die(mysqli_error($link1));
	if(mysqli_num_rows($res_state)>0){
		while($row_state=mysqli_fetch_assoc($res_state)){
			if($state_str==""){
				$state_str.="'".$row_state['stateid']."'";
			}else{
				$state_str.=",'".$row_state['stateid']."'";
			}
		}
	}else{
		$state_str="''";
	}
	return $state_str;
}
//// get access city ////
function getAccessCity($userid,$link1){
	$city_str="";
	$res_city=mysqli_query($link1,"select cityid from access_region where userid='".$userid."' and status='Y' group by cityid")or die(mysqli_error($link1));
	if(mysqli_num_rows($res_city)>0){
		while($row_city=mysqli_fetch_assoc($res_city)){
			if($city_str==""){
				$city_str.="'".$row_city['cityid']."'";
			}else{
				$city_str.=",'".$row_city['cityid']."'";
			}
		}
	}else{
		$city_str="''";
	}
	return $city_str;
}
//// get access product ////
function getAccessProduct($userid,$link1){
	$product_str="";
	$res_product=mysqli_query($link1,"select product_id from access_product where location_code in ('".$userid."') and status='Y'")or die(mysqli_error($link1));
	//if(mysqli_num_rows($res_product)>0){
	while($row_product=mysqli_fetch_assoc($res_product)){
		if($product_str==""){
			$product_str.="'".$row_product['product_id']."'";
		}else{
			$product_str.=",'".$row_product['product_id']."'";
		}
	}
	/*}else{
	$product_str="''";
	}*/
	return $product_str;
}
//// get access brand ////
function getAccessBrand($userid,$link1){
	$brand_str="";
	$res_brand=mysqli_query($link1,"select brand_id from access_brand where location_code in ('".$userid."' ) and status='Y'")or die(mysqli_error($link1));
	/*	if(mysqli_num_rows($res_brand)>0){*/
	while($row_brand=mysqli_fetch_assoc($res_brand)){
		if($brand_str==""){
			$brand_str.="'".$row_brand['brand_id']."'";
		}else{
			$brand_str.=",'".$row_brand['brand_id']."'";
		}
	}
	/*}else{
	$brand_str="''";
	}*/
	return $brand_str;
}
//////////////// FUnction for insert into store stock for Stock Leadger/////////////////
function stockLedger($inv_no,$inv_date,$itemcode,$from_party,$to_party,$stock_transfer,$stock_type,$type_name,$action_taken,$qty,$price,$create_by,$createdate,$createtime,$ip,$link1,$errorflag){
	$flag=$errorflag;
	$partdetails=mysqli_fetch_assoc(mysqli_query($link1,"select brandid, psubcatid, productid from partcode_master where partcode='".$itemcode."'"));
	$result=mysqli_query($link1,"insert into stock_ledger set reference_no='".$inv_no."',reference_date='".$inv_date."',partcode='".$itemcode."',from_party='".$from_party."', to_party='".$to_party."',owner_code='".$from_party."',stock_transfer='".$stock_transfer."',stock_type='".$stock_type."',type_of_transfer='".$type_name."',action_taken='".$action_taken."',qty='".$qty."',rate='".$price."',create_by='".$create_by."',create_date='".$createdate."',create_time='".$createtime."',create_by_ip='".$ip."',brand='".$partdetails['brandid']."',product_category='".$partdetails['productid']."',product_sub_category='".$partdetails['psubcatid']."'");
	//// check if query is not executed
	if (!$result) {
		$flag = false;
		$err_msg = "Error detailsSL: " . mysqli_error($link1) . "";
	}
	return $flag."~".$err_msg;
}
//////////////End of Store Stock Function///////////////////////////////
///// append for tracker//////////
///// Function to get status name on the statusid base//
function getFullStatus($gettingfor,$link1){
$arr_status = array();
if($gettingfor){ $used_in = " usedin = '".$gettingfor."'";}else{ $used_in = "1";}
$result_set = mysqli_query($link1,"select statusid, displayname from status_master where ".$used_in." order by displayname") or die(mysqli_error($link1));
while($row_set=mysqli_fetch_assoc($result_set)){
$arr_status[$row_set['statusid']] = $row_set['displayname'];
}
return $arr_status;
}
///// Function to get brand name on the brandid base//
function getBrandArray($link1){
	$arr_status = array();
	$result_set = mysqli_query($link1,"select brandid, brand from brand_master") or die(mysqli_error($link1));
	while($row_set=mysqli_fetch_assoc($result_set)){
		$arr_status[$row_set['brandid']] = $row_set['brand'];
	}
	return $arr_status;
}
///// Function to get product name on the productid base//
function getProductArray($link1){
	$arr_status = array();
	$result_set = mysqli_query($link1,"select productid, product_name from product_master") or die(mysqli_error($link1));
	while($row_set=mysqli_fetch_assoc($result_set)){
		$arr_status[$row_set['productid']] = $row_set['product_name'];
	}
	return $arr_status;
}
/////// function to get product sub category array with reference key product sub category id
function getProductSubCatArray($link1){
	$arr_subproduct = array();
	$res_subprod = mysqli_query($link1,"select psubcatid, prod_sub_cat from product_sub_category");
	while($row_subprod = mysqli_fetch_assoc($res_subprod)){
		$arr_subproduct[$row_subprod['psubcatid']] = $row_subprod['prod_sub_cat'];
	}
	return $arr_subproduct;
}
/////// function to get part type array with reference key type id
function getPartTypeArray($link1){
	$arr_parttype = array();
	$res_parttype = mysqli_query($link1,"select typeid, parttype from part_type_master");
	while($row_parttype = mysqli_fetch_assoc($res_parttype)){
		$arr_parttype[$row_parttype['typeid']] = $row_parttype['parttype'];
	}
	return $arr_parttype;
}
///// Function to get status name on the statusid base//
function getCityState($gettingfor,$link1){
	$arr_status = array();
	if($gettingfor){ $used_in = " cityid = '".$gettingfor."'";}else{ $used_in = "1";}
	$result_set = mysqli_query($link1,"select cityid, state, city from city_master where ".$used_in."") or die(mysqli_error($link1));
	while($row_set=mysqli_fetch_assoc($result_set)){
		$arr_status[$row_set['cityid']] = $row_set['state'].",".$row_set['city'];
	}
	return $arr_status;
}
///// Function to get status name on the statusid base//
function getTabRights($uid,$link1){
$arr_tab = array();
$result_set = mysqli_query($link1,"select tabid, status from access_tab where userid = '".$uid."'") or die("ER1GTR".mysqli_error($link1));
while($row_set=mysqli_fetch_assoc($result_set)){
$arr_tab[$row_set['tabid']] = $row_set['status'];
}
return $arr_tab;
}
///// get state ////
function getState($link1){
	$arr_state = array();
	$result_set = mysqli_query($link1,"select stateid, state from state_master order by state") or die(mysqli_error($link1));
	while($row_set=mysqli_fetch_assoc($result_set)){
		$arr_state[$row_set['stateid']] = $row_set['state'];
	}
	return $arr_state;
}
///// generic function
function getAnyDetails($keyid,$fields,$lookupname,$tbname,$link1){
	///// check no. of column
	$chk_keyword = substr_count($fields, ',');
	if($chk_keyword > 0){
		$explodee = explode(",",$fields);
		$tb_details = mysqli_fetch_array(mysqli_query($link1,"select ".$fields." from ".$tbname." where ".$lookupname." = '".$keyid."'"));
		$rtn_str = "";
		for($k=0;$k < count($explodee);$k++){
			if($rtn_str==""){
				$rtn_str.= $tb_details[$k];
			}
			else{
				$rtn_str.= "~".$tb_details[$k];
			}
		}
	}
	else{
		$tb_details = mysqli_fetch_array(mysqli_query($link1,"select ".$fields." from ".$tbname." where ".$lookupname." = '".$keyid."'"));
		$rtn_str = $tb_details[$fields];
	}
	return $rtn_str;
}
////// function to get inventory
function getInventory($locationcode,$partcode,$fields,$link1){
	$explodee=explode(",",$fields);
	$user_details = mysqli_fetch_array(mysqli_query($link1,"select ".$fields." from inventory_status where location_code='".$locationcode."' and partcode='".$partcode."'"));
	$rtn_str="";
	for($k=0;$k < count($explodee);$k++){
		if($rtn_str==""){
			$rtn_str.=$user_details[$k];
		}
		else{
			$rtn_str.="~".$user_details[$k];
		}
	}
	return $rtn_str;
}
############ Number convert into words ##############
function number_to_words($number){
	if ($number > 999999999){
		throw new Exception("Number is out of range");
	}
	$Cn = floor($number / 10000000); /* Crore () */
	$number -= $Cn * 10000000;
	//$Gn = floor($number / 1000000); /* Millions (giga) */
	//$number -= $Gn * 1000000;
	$ln = floor($number / 100000); /* Lakh () */
	$number -= $ln * 100000;
	$kn = floor($number / 1000); /* Thousands (kilo) */
	$number -= $kn * 1000;
	$Hn = floor($number / 100); /* Hundreds (hecto) */
	$number -= $Hn * 100;
	$Dn = floor($number / 10); /* Tens (deca) */
	$n = $number % 10; /* Ones */
	$cn = round(($number-floor($number))*100); /* Cents */
	$result = "";
	if ($Cn) { $result .= (empty($result) ? "" : " ") . number_to_words($Cn) . " Crore"; }
	/*if ($Gn){ $result .= number_to_words($Gn) . " Million"; }*/
	if ($ln){ $result .= (empty($result) ? "" : " ") . number_to_words($ln) . " Lakh"; }
	if ($kn){ $result .= (empty($result) ? "" : " ") . number_to_words($kn) . " Thousand"; }
	if ($Hn){ $result .= (empty($result) ? "" : " ") . number_to_words($Hn) . " Hundred"; }
	$ones = array("", "One", "Two", "Three", "Four", "Five", "Six","Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen","Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eightteen","Nineteen");
	$tens = array("", "", "Twenty", "Thirty", "Fourty", "Fifty", "Sixty","Seventy", "Eigthy", "Ninety");
	if ($Dn || $n){
		if (!empty($result)){ $result .= " ";}
		if ($Dn < 2){ $result .= $ones[$Dn * 10 + $n];}
		else{ 
			$result .= $tens[$Dn];
			if ($n){ $result .= "-" . $ones[$n];}
		}
	}
	if ($cn){
		if (!empty($result)){ $result .= ' and ';}
		$title = $cn==1 ? 'paisa': 'paise';
		$result .= strtolower(number_to_words($cn)).' '.$title;
	}
	if (empty($result)){ $result = "zero"; }
	return $result;
}
////////////////////////////////////////////// for color ///////////////// develop by 
function cellColor($cells,$color){
	global $objPHPExcel;
	$objPHPExcel->getActiveSheet()->getStyle($cells)->getFill()->applyFromArray(array(
	'type' => PHPExcel_Style_Fill::FILL_SOLID,
	'startcolor' => array(
	'rgb' => $color
	)
	));
}
///// Function to get operations rights like (Add/Edit/View/Cancel/Print/Excel) on the userid base//
function getOprRights($uid,$tabid,$link1){
	$arr_opr = array();
	$result_set = mysqli_query($link1,"select * from operation_rights where userid = '".$uid."' and tabid='".base64_decode($tabid)."'") or die(mysqli_error($link1));
	$row_set = mysqli_fetch_assoc($result_set);
	$arr_opr['add'] = $row_set['add_rgt'];
	$arr_opr['edit'] = $row_set['edit_rgt'];
	$arr_opr['view'] = $row_set['view_rgt'];
	$arr_opr['cancel'] = $row_set['cancel_rgt'];
	$arr_opr['print'] = $row_set['print_rgt'];
	$arr_opr['excel'] = $row_set['download_rgt'];
	$arr_opr['approval'] = $row_set['approval_rgt'];
	return $arr_opr;
}
////// function to calculate available qty of FG or SFG accroding to BOM
function getBomFgSfg($location_code,$partcode,$link1){
	$min_issue = 9999999999;
	$res_bom = mysqli_query($link1,"select bom_partcode, bom_qty, conversion_factor from bom_master where bom_modelcode='".$partcode."' and status='1' and bom_qty >0")or die("er1".mysqli_error($link1));
	while($row_bom = mysqli_fetch_assoc($res_bom)){
		if($row_bom['conversion_factor'] != 0){ $mfactor = $row_bom['conversion_factor'];}else{ $mfactor = 1;}
		$pur_qty = $row_bom["bom_qty"] * $mfactor;
		$avl_stock = getInventory($location_code,$row_bom['bom_partcode'],"ok_qty",$link1);
		if(!empty($avl_stock)){ $avl_stk = $avl_stock;}else{ $avl_stk = 0;}
		$minissue = round($avl_stk / $pur_qty);
        $min_issue = min($minissue, $min_issue);
	}
	if($min_issue != 9999999999){
		return $min_issue;
	}else{
		return 0;
	}
}
?>