<?php
require_once("../includes/config.php");

ini_set('max_execution_time', 300);
ini_set('memory_limit', '2048M');

/////// get Access state////////////////////////
$arrstate = getAccessState($_SESSION['userid'],$link1);

//// extract all encoded variables
$tostate = base64_decode($_REQUEST['to_state']);
$toloc = base64_decode($_REQUEST['to_loc']);
$statusid = base64_decode($_REQUEST['status_id']);
/// filters value/////
//////// get date /////////////////////////
if ($_REQUEST['daterange'] != ""){
	$date_range = explode(" - ",$_REQUEST['daterange']);
	$daterange = "and sale_date  >= '".$date_range[0]."' and sale_date  <= '".$date_range[1]."'";
}
else{
	$daterange = "and 1";
}

## selected  to_loc
if($toloc != ""){
	$to_location = " to_location in ('".$toloc."')";
}else if($tostate != ""){
	$to_location = " to_stateid in ('".$tostate."')";
}else{
	$to_location = " to_stateid in (".$arrstate.") ";
}

## selected  status
if($statusid != ""){
	$status_str = " and status = '".$statusid."' ";
}else {
	$status_str = " and 1 ";
}

//////End filters value/////

/** Include PHPExcel */
require_once("../ExcelExportAPI/Classes/PHPExcel.php");
//require_once dirname(__FILE__) . '/../Classes/PHPExcel.php';


// Create new PHPExcel object
$objPHPExcel = new PHPExcel();

// Set document properties
$objPHPExcel->getProperties()->setCreator("Candour Software")
							 ->setLastModifiedBy("Candour Software")
							 ->setTitle("Office 2007 XLSX Test Document")
							 ->setSubject("Office 2007 XLSX Test Document")
							 ->setDescription("Test document for Office 2007 XLSX.")
							 ->setKeywords("office 2007 openxml php")
							 ->setCategory("Summarize Sales Dispatch");


// Add some data		
$objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'S.No.')
            ->setCellValue('B1', 'Invoice Type')
            ->setCellValue('C1', 'Courier')
         	->setCellValue('D1', 'Docket no')
			->setCellValue('E1', 'Docket date')
			
			->setCellValue('F1', 'From Location Code')
			->setCellValue('G1', 'From Location Name')
			->setCellValue('H1', 'From Location State')
			->setCellValue('I1', 'GSTIN /UIN of From Location')
			
			->setCellValue('J1', 'To Location Code')
			->setCellValue('K1', 'To Location Name')
			->setCellValue('L1', 'To Location State')
			->setCellValue('M1', 'GSTIN /UIN of To Location')
			
			->setCellValue('N1', 'Type Of PO')
			->setCellValue('O1', 'PO / PNA No.')
			->setCellValue('P1', 'PO / PNA Date')
			
			->setCellValue('Q1', 'Invoice number')
			->setCellValue('R1', 'Invoice date')
			
			->setCellValue('S1', 'Total Basic price')
			->setCellValue('T1', 'IGST Tax Amount')
			->setCellValue('U1', 'CGST Tax Amount')
			->setCellValue('V1', 'SGST Tax Amount')
			->setCellValue('W1', 'Total Invoice Value')
			->setCellValue('X1', 'Status')
			->setCellValue('Y1', 'Asc Receive Date');			
			
///////////////////////
cellColor('A1:Y1', 'F28A8C');
///////////////////////////////////////////////

// Miscellaneous glyphs, UTF-8
$i=2;
$count=1;

$sql_loc=mysqli_query($link1,"Select * from billing_master where (po_type='PO' or po_type='PNA' ) ".$status_str." ".$daterange." and ".$to_location." ");

while($row_loc = mysqli_fetch_array($sql_loc)){
	
$po_dt = getAnyDetails($row_loc['po_no'],"po_date","po_no","po_master",$link1);	
	
$objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A'.$i, $count)
			->setCellValue('B'.$i, $row_loc['document_type'])
			->setCellValue('C'.$i, $row_loc['courier'])
			->setCellValue('D'.$i, $row_loc['docket_no'])
			->setCellValue('E'.$i, dt_format2($row_loc['dc_date']))
			
			->setCellValue('F'.$i, $row_loc['from_location'])
			->setCellValue('G'.$i, getAnyDetails($row_loc['from_location'],"locationname","location_code","location_master",$link1))
			->setCellValue('H'.$i, getAnyDetails($row_loc['from_stateid'],"state","stateid","state_master",$link1))
			->setCellValue('I'.$i, $row_loc['from_gst_no'])
			
			->setCellValue('J'.$i, $row_loc['to_location'])
			->setCellValue('K'.$i, getAnyDetails($row_loc['to_location'],"locationname","location_code","location_master",$link1))
			->setCellValue('L'.$i, getAnyDetails($row_loc['to_stateid'],"state","stateid","state_master",$link1))
			->setCellValue('M'.$i, $row_loc['to_gst_no'])
			
			->setCellValue('N'.$i, $row_loc['po_type'])
			->setCellValue('O'.$i, $row_loc['po_no'])
			->setCellValue('P'.$i, dt_format($po_dt))
			
			->setCellValue('Q'.$i, $row_loc['challan_no'])
			->setCellValue('R'.$i, dt_format2($row_loc['sale_date']))
			
			->setCellValue('S'.$i, $row_loc['basic_cost'])
			->setCellValue('T'.$i, $row_loc['igst_amt'])
			->setCellValue('U'.$i, $row_loc['cgst_amt'])
			->setCellValue('V'.$i, $row_loc['sgst_amt'])
			->setCellValue('W'.$i, $row_loc['total_cost'])
			->setCellValue('X'.$i, getDispatchStatus($row_loc['status']))
			->setCellValue('Y'.$i, dt_format($row_loc['receive_date']));
			
			$count++;
			$i++;					
}
// Rename worksheet
$objPHPExcel->getActiveSheet()->setTitle('Sales Dispatch');


// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);


// Redirect output to a client?s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="sales_dispatch_detail_report.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;
