<?php
require_once("../includes/config.php");

/** Include PHPExcel */
require_once("../ExcelExportAPI/Classes/PHPExcel.php");
//require_once dirname(__FILE__) . '/../Classes/PHPExcel.php';


// Create new PHPExcel object
$objPHPExcel = new PHPExcel();

// Set document properties
$objPHPExcel->getProperties()->setCreator("Candour Software")
							 ->setLastModifiedBy("Candour Software")
							 ->setTitle("Office 2007 XLSX Test Document")
							 ->setSubject("Office 2007 XLSX Test Document")
							 ->setDescription("Test document for Office 2007 XLSX.")
							 ->setKeywords("office 2007 openxml php")
							 ->setCategory("UPLOAD_MODEL_EDIT");


// Add some data
$objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'MODEL ID')
            ->setCellValue('B1', 'MODEL NAME')
            ->setCellValue('C1', 'TECH. NAME')
         	->setCellValue('D1', 'COMP. MODEL')
			->setCellValue('E1', 'SERVICE CHARGE')
			->setCellValue('F1', 'SERIAL NO. LENGTH')
			->setCellValue('G1', 'SOFTWARE VERSION')
			->setCellValue('H1', 'AMC DAYS')
			->setCellValue('I1', 'AMC AMOUNT')
			->setCellValue('J1', 'REPAIR WARRANTY DAYS')
			->setCellValue('K1', 'MAKE DOA (Y/N)')
			->setCellValue('L1', 'DOA DAY')
			->setCellValue('M1', 'REPLACEMENT (Y/N)')
			->setCellValue('N1', 'REPLACE DAYS')
			->setCellValue('O1', 'WARRANTY DAYS')
			->setCellValue('P1', 'MAKE JOB (Y/N)')
			->setCellValue('Q1', 'REPAIRABLE (Y/N)')
			->setCellValue('R1', 'OUT WARRANTY (Y/N)')
			->setCellValue('S1', 'CHECK SERIAL NO (Y/N)')
		    ->setCellValue('T1', 'TERM AND CONDITION');
			 
////////////////
///////////////////////
cellColor('A1:T1', 'F28A8C');

////////////////////////////////

///////////////////////////////////////////////
// Miscellaneous glyphs, UTF-8
$i=2;
$count=1;
$sql_loc = mysqli_query($link1,"Select * from model_master where 1 ");

while($row_loc = mysqli_fetch_array($sql_loc)){

$objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A'.$i, $row_loc['model_id'])
			->setCellValue('B'.$i, $row_loc['model'])
			->setCellValue('C'.$i, $row_loc['technical_model'])
			->setCellValue('D'.$i, $row_loc['ven_code'])
			->setCellValue('E'.$i, $row_loc['ser_charge'])
			->setCellValue('F'.$i, $row_loc['len_serialno'])
			->setCellValue('G'.$i, $row_loc['software_version'])
			->setCellValue('H'.$i, $row_loc['amc_days'])
			->setCellValue('I'.$i, $row_loc['amc_amount'])
			->setCellValue('J'.$i, $row_loc['rep_warr_days'])
         	->setCellValue('K'.$i, $row_loc['make_doa'])
			->setCellValue('L'.$i, $row_loc['doa_days'])		
			->setCellValue('M'.$i, $row_loc['replacement'])
			->setCellValue('N'.$i, $row_loc['replace_days'])
			->setCellValue('O'.$i, $row_loc['wp'])
			->setCellValue('P'.$i, $row_loc['make_job'])
			->setCellValue('Q'.$i, $row_loc['repairable'])
			->setCellValue('R'.$i, $row_loc['out_warranty'])
			->setCellValue('S'.$i, $row_loc['chk_serimei'])
			->setCellValue('T'.$i, $row_loc['amc_desc']);
			
			$i++;	
			$count++;
		
}
// Rename worksheet
$objPHPExcel->getActiveSheet()->setTitle('UPLOAD_MODEL_EDIT');


// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);


// Redirect output to a clients web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="UPLOAD_MODEL_EDIT.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;
