<?php
include('constant.php');
class Rest {
	protected $request;
	protected $serviceName;
	protected $param;
	protected $link; 
	public function __construct(){
		//print_r($_SERVER);
		//exit;
		if($_SERVER['REQUEST_METHOD']!='POST'){
			
			$this->throwError(REQUEST_METHOD_NOT_VALID,"Request method is not valid");
			
		}
		
		$handler = fopen("php://input",'r');
		$this->request = stream_get_contents($handler);
		$db = new DB();
		$this->link=$db->link;
		///print_r($db->link);
		//print_r($db);
		//echo "<pre>";
		//print_r($_SERVER);
		//echo "</pre>";
		$this->validateRequest();
	
		if('generatetoken' != strtolower($this->serviceName)){
			
			$this->validateToken();
		}
		
	}
	
	public function validateRequest(){
		
		if($_SERVER['CONTENT_TYPE'] != 'application/json'){
			
			$this->throwError(REQUEST_CONTENTTYPE_NOT_VALID,"Request content-type is not valid");
		}
		
		$data = json_decode($this->request,true);
		
		if(!isset($data['name']) || $data['name']==""){
			
			$this->throwError(API_NAME_REQUIRED,"API name is required");
		}
		if(!is_array($data['param'])){
			
			$this->throwError(API_PARAM_REQUIRED,"API param is required");
			
		}
		
		$this->serviceName = $data['name'];
		$this->param = $data['param'];
        $this->token = $data['token'];
		
		
	}
	public function validateParameter($paraMeter,$value,$dataType,$required = true){
		
		if($required == true && (empty($value) && $value!=0)){
			
			$this->throwError(VALIDATE_PARAMETER_REQUIRED,$paraMeter.' is required');
		}
		
		switch($dataType){
			
			case BOOLEAN:
			
			if(!is_bool($value)){
				
				$this->throwError(VALIDATE_PARAMETER_DATATYPE,'Data type is not valid for '.$paraMeter);
				
			}
			break;
			
			case INTEGER:
			if(!is_numeric($value)){
				
				$this->throwError(VALIDATE_PARAMETER_DATATYPE,'Data type is not valid for '.$paraMeter);
				
			}
			break;
			
			case STRING:
			if(!is_string($value)){
				
				$this->throwError(VALIDATE_PARAMETER_DATATYPE,'Data type is not valid for '.$paraMeter);
				
			}
			break;
			
			default :
			
			break;		
			
		}
		
		
		return $value;
		

	}
	public function processApi(){
		$api = new API();
		try {
			
		 $rMethod = new reflectionMethod('API',$this->serviceName);
		 
		}catch(Exception $e){
			
			$this->throwError(API_DOES_NOT_EXIST,"API dose't exist");
		}
		
		$rMethod->invoke($api);
		
	}
	public function throwError($code,$message){
		
		header("Content-Type:application/json");
		$error = json_encode(["error"=>["code"=>$code,"message"=>$message]]);
		echo $error;
		exit;

	}
	public function returnResponse($code,$pager,$message){

		header("Content-Type:application/json");
		if(!is_array($pager)){
			$response = json_encode(["response"=>["code"=>$code,"message"=>$message]]);
		}else{
			$response = json_encode(["response"=>["code"=>$code,"pager"=>$pager,"message"=>$message]]);
		}
		echo $response;
		exit;
	
	}
	public function getAuthorizationHeader(){
        $headers = null;
        if (isset($_SERVER['Authorization'])) {
            $headers = trim($_SERVER["Authorization"]);
			
        }
        else if (isset($_SERVER['HTTP_AUTHORIZATION'])) { //Nginx or fast CGI
            $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
			
        } elseif (function_exists('apache_request_headers')) {
            $requestHeaders = apache_request_headers();
		
            // Server-side fix for bug in old Android versions (a nice side-effect of this fix means we don't care about capitalization for Authorization)
            $requestHeaders = array_combine(array_map('ucwords', array_keys($requestHeaders)), array_values($requestHeaders));
           
            if (isset($requestHeaders['Authorization'])) {
                $headers = trim($requestHeaders['Authorization']);
            }
			
        }
		
        return $headers;
    }
	/**
	 * get access token from header
	 * */
	public function getBearerToken() {
		 $headers = $this->getAuthorizationHeader();
		// HEADER: Get the access token from the header
		if (!empty($headers)) {
			if (preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
				return $matches[1];
			}
		}
		$this->throwError(AUTHORIZATION_HEADER_NOT_FOUND,"Access Token not found");
	}
	public function validateToken(){
		
		try{
			///$token = $this->getBearerToken();
            $token = $this->token;
			$payload = JWT::decode($token,SECURTY_KEY,['HS256']);
			$custQuery = mysqli_query($this->link,"select * from locationuser_master where id='".$payload->userId."'");
			$customer = mysqli_fetch_assoc($custQuery);
			
			if(!is_array($customer)){
				
				$this->throwError(USER_NOT_FOUND,'User is not found');
			}
			
			if($customer['status']=="Deactive"){
				
				$this->throwError(USER_NOT_ACTIVE,'User is not active');
				
			}
			
			
		}catch(Exception $e){
			
			$this->throwError(ACESS_TOKEN_ERROR,$e->getMessage());
			
		}
		
		
		
	}
	
	
	
	
	
	
}
?>