<?php
require_once("../includes/config.php");

ini_set('max_execution_time', 300);
ini_set('memory_limit', '2048M');

/////// get Access brand////////////////////////
$access_brand = getAccessBrand($_SESSION['userid'],$link1);
/////// get Access product category////////////////////////
$access_product = getAccessProduct($_SESSION['userid'],$link1);

/////// get Access state////////////////////////
$arrstate = getAccessState($_SESSION['userid'],$link1);

//// extract all encoded variables
$tostate = base64_decode($_REQUEST['to_state']);
$toloc = base64_decode($_REQUEST['to_loc']);
$brandid = base64_decode($_REQUEST['brand']);
$productid = base64_decode($_REQUEST['prod_code']);

////// filters value/////
//////// get date /////////////////////////
if ($_REQUEST['daterange'] != ""){
	$date_range = explode(" - ",$_REQUEST['daterange']);
	$daterange = " and (sale_date  >= '".$date_range[0]."' and sale_date  <= '".$date_range[1]."')";
}
else{
	$daterange = "and 1";
}

## selected  to_loc
if($toloc != ""){
	$to_location = "and to_location in ('".$toloc."')";
}else if($tostate != ""){
	$to_location = "and to_stateid in ('".$tostate."')";
}else{
	$to_location = "and to_stateid in (".$arrstate.") ";
}

## selected  brand
if($brandid != ""){
	$brand_id = " and partcode  in (select partcode from partcode_master where brand_id  = '".$brandid."' ) ";
}else {
	$brand_id=" and 1 ";
}

## selected  brand
if($productid != ""){
	$product_id = " and partcode  in (select partcode from partcode_master where product_id = '".$productid."' ) ";
}else {
	$product_id=" and 1 ";
}

//////End filters value/////

/** Include PHPExcel */
require_once("../ExcelExportAPI/Classes/PHPExcel.php");
//require_once dirname(__FILE__) . '/../Classes/PHPExcel.php';


// Create new PHPExcel object
$objPHPExcel = new PHPExcel();

// Set document properties
$objPHPExcel->getProperties()->setCreator("Candour Software")
							 ->setLastModifiedBy("Candour Software")
							 ->setTitle("Office 2007 XLSX Test Document")
							 ->setSubject("Office 2007 XLSX Test Document")
							 ->setDescription("Test document for Office 2007 XLSX.")
							 ->setKeywords("office 2007 openxml php")
							 ->setCategory("Partwise Sales Counter");

// Add some data
$objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'S.No.')
            ->setCellValue('B1', 'Invoice Type')
            
			->setCellValue('C1', 'From Location Code')
			->setCellValue('D1', 'From Location Name')
			->setCellValue('E1', 'City of Form Location Invoice')
			->setCellValue('F1', 'State of From Location Invoice')
			->setCellValue('G1', 'GSTIN / UIN of From Location')
			
			->setCellValue('H1', 'Customer Name')
			
			->setCellValue('I1', 'Type')
			->setCellValue('J1', 'Job No')
			
			->setCellValue('K1', 'Brand Name')
			->setCellValue('L1', 'Product Name')
			->setCellValue('M1', 'Model')
			
			->setCellValue('N1', 'Partcode')
			->setCellValue('O1', 'Part Description')
			->setCellValue('P1', 'UQC of goods sold')
			->setCellValue('Q1', 'HSN')
			
			->setCellValue('R1', 'Quantity of goods sold')	
			->setCellValue('S1', 'Unit Price')	
			->setCellValue('T1', 'Total')
			
			->setCellValue('U1', 'IGST Rate')
			->setCellValue('V1', 'IGST Tax Amount')
			->setCellValue('W1', 'SGST Rate')
			->setCellValue('X1', 'SGST Tax Amount')	
			->setCellValue('Y1', 'CGST Rate')
			->setCellValue('Z1', 'CGST Tax Amount')
			->setCellValue('AA1', 'Total with GST')
			
			->setCellValue('AB1', 'Invoice number')
			->setCellValue('AC1', 'Invoice date')
			->setCellValue('AD1', 'Total Invoice Value')
						
			->setCellValue('AE1', 'ASP unit price')
			->setCellValue('AF1', 'ASP total Price')
			->setCellValue('AG1', 'ASP total GST')
			->setCellValue('AH1', 'ASP price with GST');
			
///////////////////////
cellColor('A1:AH1', 'F28A8C');
///////////////////////////////////////////////
// Miscellaneous glyphs, UTF-8
$i=2;
$count=1;

$sql_loc=mysqli_query($link1, "Select * from billing_master where po_type='RETAIL' ".$daterange."  ".$to_location." ");
while($row_loc = mysqli_fetch_array($sql_loc)){
	
$tsgst = 0.00;
$tcgst = 0.00;
$tigst = 0.00;
$tt = 0.00;
	
$sql = mysqli_query($link1, "Select * from billing_product_items where challan_no= '".$row_loc['challan_no']."'  ".$brand_id." ".$product_id."  ");
while($row = mysqli_fetch_array($sql)){
	
$tsgst += $row['sgst_amt'];
$tcgst += $row['cgst_amt'];
$tigst += $row['igst_amt'];
$tt += $row['item_total'];

$partdis="";
if($row['partcode']!="SERVICE"){
	$partdis=getAnyDetails($row['partcode'],"part_desc","partcode","partcode_master",$link1); 
}else{
	$partdis="SERVICE";
}

$tolocation="";
if($row['to_location']!=""){
	$toloc=getAnyDetails($row['to_location'],"locationname","location_code","location_master",$link1);
	if($toloc){
		$tolocation=$toloc;
	}else{
		$tolocation=$row['to_location'];
	}
}else{
	$tolocation=$row['to_location'];
}	

$ctyf=getAnyDetails($row_loc['from_location'],"cityid","location_code","location_master",$link1);
$ctyt=getAnyDetails($row_loc['to_location'],"cityid","location_code","location_master",$link1);

if($row['partcode']!="SERVICE"){
	$part_info = mysqli_fetch_array(mysqli_query($link1, "select brand_id, product_id, location_price from partcode_master where partcode = '".$row['partcode']."' "));
	$prt_brd = $part_info['brand_id'];
	$prt_prd = $part_info['product_id'];
	$prt_loc_prc = $part_info['location_price'];
}else{
	$prt_brd = $row['brand_id'];
	$prt_prd = $row['product_id'];
	$prt_loc_prc = 0;
}

$af_val = ($prt_loc_prc * $row['qty']);
$ag_val = (($af_val * 18) / 100);
$ah_val = ($af_val + $ag_val);

$po_dt = getAnyDetails($row_loc['po_no'],"po_date","po_no","po_master",$link1);

$basc = ($row['item_total'] - ($row['igst_amt'] + $row['cgst_amt'] + $row['sgst_amt']));

$objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A'.$i, $count)
			->setCellValue('B'.$i, $row_loc['document_type'])
			
			->setCellValue('C'.$i, $row['from_location'])
			->setCellValue('D'.$i, getAnyDetails($row['from_location'],"locationname","location_code","location_master",$link1))
			->setCellValue('E'.$i, getAnyDetails($ctyf,"city","cityid","city_master",$link1))
			->setCellValue('F'.$i, getAnyDetails($row_loc['from_stateid'],"state","stateid","state_master",$link1))
			->setCellValue('G'.$i, $row_loc['from_gst_no'])
			
			->setCellValue('H'.$i, $tolocation)
			
			->setCellValue('I'.$i, $row_loc['po_type'])
			->setCellValue('J'.$i, $row['job_no'])
			
			->setCellValue('K'.$i, getAnyDetails($prt_brd,"brand","brand_id","brand_master",$link1))
			->setCellValue('L'.$i, getAnyDetails($prt_prd,"product_name","product_id","product_master",$link1))
			->setCellValue('M'.$i, getAnyDetails($row['model_id'],"model","model_id","model_master",$link1))
			
			->setCellValue('N'.$i, $row['partcode'])
			->setCellValue('O'.$i, $partdis)
			->setCellValue('P'.$i, $row['uom'])
			->setCellValue('Q'.$i, $row['hsn_code'])
			
			->setCellValue('R'.$i, $row['qty'])
			->setCellValue('S'.$i, $row['price'])
			->setCellValue('T'.$i, $basc)
			
			->setCellValue('U'.$i, $row['igst_per'])
			->setCellValue('V'.$i, $row['igst_amt'])
			->setCellValue('W'.$i, $row['sgst_per'])
			->setCellValue('X'.$i, $row['sgst_amt'])
			->setCellValue('Y'.$i, $row['cgst_per'])
			->setCellValue('Z'.$i, $row['cgst_amt'])
			->setCellValue('AA'.$i, $row['item_total'])
			
			->setCellValue('AB'.$i, $row_loc['challan_no'])
			->setCellValue('AC'.$i, dt_format2($row_loc['sale_date']))
			->setCellValue('AD'.$i, $row_loc['total_cost'])
			
			->setCellValue('AE'.$i, $prt_loc_prc)
			->setCellValue('AF'.$i, $af_val)
			->setCellValue('AG'.$i, $ag_val)
			->setCellValue('AH'.$i, $ah_val);
						
			$i++;
			$count++;
			}
					
}
// Rename worksheet
$objPHPExcel->getActiveSheet()->setTitle('Counter Sales');


// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);


// Redirect output to a client?s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="sales_counter_partwise_report.xlsx"');
header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;
